# -*- coding: utf-8 -*-
from ladon.ladonizer import ladonize
from mysite.pywebsv.utils import SUCCESS_CODE, MESSAGE_CODE, SYSTEM_EXCEPTION, DATA_EXCEPTION, interface_response, request_valid
import json


class BioTimeAppDepartment(object):

    """
    【Department】部门
    """

    @request_valid
    @ladonize(int, str, str, str, rtype=str)
    def pull_department(self, source, device_token, language, token):
        """
        获取部门树
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功
                {"code":1, "error":"", "describe":"", "message":"", "data":[{"code":对象ID,"name":"部门名字","parent_id":父部门ID,"subs":"子部门"}]}
            请求失败
                {"code":-10001, "error":"", "describe":"", "message":"", "data":""}
        """
        from django.utils.cache import cache
        from mysite.personnel.models.model_dept import Department
        try:
            dept_tree = cache.get('app_dept_tree', None)
            if not dept_tree:
                depts = Department.objects.all().values('id', 'name', 'parent_id').order_by('code')
                dept_tree = []
                subs = {}
                for dept in depts:
                    parent = dept['parent_id']
                    if parent:
                        if parent not in subs:
                            subs[parent] = []
                        subs[parent].append({'code': dept['id'], 'name': dept['name'], 'parent_id': parent, 'subs': []})
                    else:
                        dept_tree.append({'code': dept['id'], 'name': dept['name'], 'parent_id': ''})

                def get_subs(obj):
                    print obj
                    p_subs = subs.get(obj['code'], [])
                    if p_subs:
                        for sub in p_subs:
                            get_subs(sub)
                        obj['subs'] = p_subs
                map(lambda x: get_subs(x), dept_tree)
                cache.set('app_dept_tree', dept_tree)
            return interface_response(SUCCESS_CODE, json.dumps(dept_tree), '', 'successful')
        except Exception, e:
            import traceback
            traceback.print_exc()
            return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)
